// missionMenus by Shayk-N'-Bake
// Place this file anywhere on your server where it can be executed, preferably config folder and called from autoexec.
// This overwrites all of the mission menu functions loaded on the server during startup, to include nicer menu
// navigation for easier sorting through mission types and mission lists. This does not require any other menu code to
// be in your mod and, unless you have altered the original ways of menu selecting in menu.cs, should not have a problem
// with any other menu modifications you might have made.

// The primary reason I made this was to make it so servers that change mods regularly can keep a nice mission menu
// that will display all of the missions on the servers, even in older mods where this kind of modification might not
// have been done yet. Even the way newer mods generally do it is rather inconvenient, and does not allow for
// back-tracking. I consider this the best one out.

function processMenuCMission(%clientId, %option)
{
	if(getWord(%option, 0) == "more")
	{
		%first = getWord(%option, 1);
		%type = getWord(%option, 2);
		%page = getWord(%option, 3);
		%page++;
		processMenuCMType(%clientId, %type @ " " @ %first @ " " @ %page);
		return;
	}
	else if(getWord(%option, 0) == "back")
	{
		%first = getWord(%option, 1);
		%type = getWord(%option, 2);
		%page = getWord(%option, 3);
		%page--;
		processMenuCMType(%clientId, %type @ " " @ %first @ " " @ %page);
		return;
	}
	else if(getWord(%option, 0) == "backtypes")
	{
		Admin::changeMissionMenu(%clientId, %opt == "cmission");
		return;
	}
	
	%mi = getWord(%option, 0);
	%mt = getWord(%option, 1);
	%misName = $MLIST::EName[%mi];
	%misType = $MLIST::Type[%mt];
	// verify that this is a valid mission:
	if(%misType == "" || %misType == "Training") 
		return;
	for(%i = 0; true; %i++)
	{
		%misIndex = getWord($MLIST::MissionList[%mt], %i);
		if(%misIndex == %mi) 
			break;
		if(%misIndex == -1) 
			return;
	}
	if(%clientId.isAdmin)
	{
		messageAll(0, Client::getName(%clientId) @ " changed the mission to " @ %misName @ " (" @ %misType @ ")");
		Vote::changeMission();
		Server::loadMission(%misName);
	}
	else
	{
		Admin::startVote(%clientId, "change the mission to " @ %misName @ " (" @ %misType @ ")", "cmission", %misName);
		Game::menuRequest(%clientId);
	}
}

function Admin::changeMissionMenu(%clientId, %voteit)
{
	Client::buildMenu(%clientId, "Shayk's Mission Menu: Choose Type", "cmtype", true);
	%index = 0;
	for(%type = 0; %type < $MLIST::TypeCount; %type++)
	{
		if($MLIST::Type[%type] != "Training")
		{
			if(%index > 6 && $MLIST::TypeCount > 8)
			{
				Client::addMenuItem(%clientId, %index+1 @" .. Next Mission Types", "more 8 0");
				break;
			}
			Client::addMenuItem(%clientId, %index+1 @ $MLIST::Type[%type], %type @" -1 0");
			%index++; 
		}
	}
}

function processMenuCMoo(%clientId, %options)
{
	%first = getWord(%options, 0);
	%page = getWord(%options, 1);
	
	Client::buildMenu(%clientId, "Shayk's Mission Menu: Choose Type", "cmtype", true); 
	if(%page != 0)
	{
		Client::addMenuItem(%clientId, "1 .. Previous Mission Types", "back " @ %first-7 @ " " @ %page);
		%index = 1;
		for(%type = %first; %type < $MLIST::TypeCount; %type++)
		{
			if($MLIST::Type[%type] != "Training")
			{
				if(%index > 6 && $MLIST::TypeCount > %first + %index)
				{
					Client::addMenuItem(%clientId, %index+1 @ " .. Next Mission Types", "more " @ %first + %index @ " " @ %page); 
					break; 
				}
				Client::addMenuItem(%clientId, %index+1 @ $MLIST::Type[%type], %type @ " -1 0"); 
				%index++; 
			} 
		}
	}
	else
	{
		%index = 0;
		for(%type = 0; %type < $MLIST::TypeCount; %type++)
		{
			if($MLIST::Type[%type] != "Training")
			{
				if(%index > 6 && $MLIST::TypeCount > %first + %index)
				{
					Client::addMenuItem(%clientId, %index+1 @ " .. Next Mission Types", "more " @ %first + %index @ " " @ %page); 
					break; 
				}
				Client::addMenuItem(%clientId, %index+1 @ $MLIST::Type[%type], %type @ " -1 0"); 
				%index++; 
			} 
		}
	}
}

function processMenuCMType(%clientId, %options)
{
	%option = getWord(%options, 0);
	%first = getWord(%options, 1);
	%page = getWord(%options, 2);
	
	if(%option == "more")
	{
		%page++;
		processMenuCMoo(%clientId, %first @ " " @ %page); 
		return;
	}
	else if(%option == "back")
	{
		%page--;
		processMenuCMoo(%clientId, %first @ " " @ %page); 
		return;
	}
	
	Client::buildMenu(%clientId, "Shayk's Mission Menu: Choose Map", "cmission", true);
	if(%page != 0)
	{
		//%curItem = 1;
		Client::addMenuItem(%clientId, "1 .. Previous Missions", "back " @ %first-7 @ " " @ %option @ " " @ %page);
		for(%i = 1; (%misIndex = getWord($MLIST::MissionList[%option], %first + %i)) != -1; %i++)
		{
			if(%i > 6)
			{
				Client::addMenuItem(%clientId, %i+1 @ " .. Next Missions", "more " @ %first + %i @ " " @ %option @ " " @ %page);
				break;
			}
			Client::addMenuItem(%clientId, %i+1 @ $MLIST::EName[%misIndex], %misIndex @ " " @ %option);
		}
	}
	else
	{
		//%curItem = 0;
		Client::addMenuItem(%clientId, "1 .. Mission Type List", "backtypes"); 
		for(%i = 1; (%misIndex = getWord($MLIST::MissionList[%option], %first + %i)) != -1; %i++)
		{
			if(%i > 6)
			{
				Client::addMenuItem(%clientId, %i+1 @ " .. Next Missions", "more " @ %first + %i @ " " @ %option @ " " @ %page);
				break;
			}
			Client::addMenuItem(%clientId, %i+1 @ $MLIST::EName[%misIndex], %misIndex @ " " @ %option);
		}
	}
}